function [x y]=fAdamsBas3(fun,x0,xf,y0,Nh)
% ---------------------------------------------
% FADAMSBAS3: Resuelve ecuaciones diferenciales del tipo y'=f(x,y)
% usando el mtodo de Adams Basforth de tercer orden utilizando una malla
% equiespaciada con Nh intervalos.
% Este mtodo es explcito y multipaso de 3 pasos. Hace una llamada al
% mtodo de Runge-Kutta de 4 orden (rutina fRK4) para obtener dos puntos adicionales a
% partir de las condiciones iniciales.
%
% PARMETROS DE ENTRADA:
% fun: funcin annima (puntero a funcin). Es importante que la funcin est definida como
% una funcin de dos variables f(x,y;k1,k2,..,kn) por este orden.
% k1,k2,..,kn son todos los otros parmetros que puede haber en la funcin
% y a los que tenemos que dar valores al definir la funcin annima.
% x0: valor inicial de la variable independiente
% xf: valor final de la variable independiente
% y0: variable con el valor inicial de y
% Nh: nmero de intervalos que tomamos entre el instante inicial y final.
% Por ejemplo, si Nh=3, dividimos el tiempo entre el instante inicial y el
% final en tres intervalos.
% varargin: los valores de los parmetros k1,k2,..,kn que puede haber en la funcin
%
% PARMETROS DE SALIDA:
% x: vector columna con los valores de la variable independiente en los que se ha
% evaluado y.
% y: vector columna con lo valores de la funcin y
% -----------------------------------------------------
h = (xf-x0)/Nh;
x=zeros(1,Nh+1);    % Vector para los valores de x
y=zeros(1,Nh+1);    % Vector para los valores de y
f=zeros(1,Nh+1);    % Vector para los valores de la derivada dy/dx
x(1)=x0;
y(1)=y0;
f(1)=fun(x0,y0);
% Necesitamos tres puntos. Tengo que usar un mtodo de un slo paso.
% Uso el mtodo de Runge-Kutta de cuarto orden.
Naux = 2;
xfaux = x0+2*h;
[xaux,yaux]=fRK4(fun,x0,xfaux,y0,Naux);
x(2)=xaux(2);
y(2)=yaux(2);
f(2)= fun(x(2),y(2));
x(3)=xaux(3);
y(3)=yaux(3);
f(3)=fun(x(3),y(3));
% Ya tenemos tres puntos. Podemos usar el mtodo de Adams-Basforth
for j=4:1:Nh+1
    y(j) = y(j-1) + h/12*(23*f(j-1)-16*f(j-2)+5*f(j-3));
    x(j) = x(j-1) + h;
    f(j) = fun(x(j),y(j));
end
end


